libname q 'c:\SASCodeforBook\SASDataSets';
Data First; set q.frauddata;

sixoffices = sofice35;
design3 = threclas;
officetypeCFRD = TESPonly;
OfficetypeM2K = V2Konly;
OfficetypeOneSys = OneSys;
OfficetypeBothSys = BothSys;
OfficetypeNoNewSys = ZeroSys;
antiIndex=nwanti3;
run;

data second; set first;

	/*REML Estimates of Multilevel Models, BICs Plotted in Figure 5.3*/

Title 'Baseline Random Intercepts Model, Random Intercepts, REML Estimates';
	Proc Mixed data = first covtest ratio cl;
	class sixoffices;
	model AntiIndex = /cl s;
	random SixOffices / s cl;
run;

Title 'Model 1, REML Estimates for Chapter 5, Equation 3, 
	employee level variables only';
	Proc Mixed data = first covtest ratio cl;
	class sixoffices;
	model AntiIndex = fac1_1 fac2_1 /cl s;
run;

Title 'Model 2,REML Estimates for Chapter 5, Equation 4, employee level variables grouped within offices';
	Proc Mixed data = first covtest ratio cl;
	class sixoffices;
	model AntiIndex = fac1_1 fac2_1 /cl s;
	random SixOffices / s cl;
run;

Title 'Model 3,REML Estimate for Chapter 5, Equation 5, employee level variables grouped within offices,
	with OfficeType= Both Sys, No nesting of Random Offices';
	Proc Mixed data = first covtest ratio cl;
	class sixoffices;
	model AntiIndex = fac1_1 fac2_1 OfficetypeBothSys /cl s;
	random SixOffices / s cl;
run;

/*This code illustrates the nesting of the categories of the random offices by the office type*/
Title 'Model 3a,REML Estimates for Chapter 5, Equation 5, employee level variables grouped within offices,
	with OfficeType= Both Sys, nesting of Random Offices within OfficeTypeBothSys';
	Proc Mixed data = first covtest ratio cl;
	class sixoffices OfficetypeBothSys;
	model AntiIndex = fac1_1 fac2_1 OfficetypeBothSys /cl s;
	random SixOffices(OfficeTypeBothSys) / s cl;
run;

	/*This code tests the cross-level interaction effects with REML estimates*/

Title 'Model 4,REML Estimates for Interaction Effects,Office Type BothSystems';
	Proc Mixed data = first covtest ratio cl;
	class sixoffices;
	model AntiIndex = OfficeTypeBothSys fac1_1 fac1_1*OfficeTypeBothSys
		fac2_1 fac2_1*OfficetypeBothSys /cl s;
	*random SixOffices / s cl;
run;

/* This code provides the Maximum Likelihood Estimates of the -2ll and BIC for the Baseline Model,
	Model 2, and Model 3 as plotted in Figure 5.3*/

Title 'Baseline Random Intercepts Model, Random Intercepts, ML Estimates';
	Proc Mixed data = first covtest ratio cl method=ml;
	class sixoffices;
	model AntiIndex = /cl s;
	random SixOffices / s cl;
run;

Title 'Model 2,ML Estimates for Equation 5.4, employee level variables grouped within offices';
	Proc Mixed data = first covtest ratio cl method= ml;
	class sixoffices;
	model AntiIndex = fac1_1 fac2_1 /cl s;
	random SixOffices / s cl;
run;

Title 'Model 3,ML Estimate for Equation 5.5, employee level variables grouped within offices,
	with OfficeType= Both Sys, No nesting of Random Offices';
	Proc Mixed data = first covtest ratio cl method=ml;
	class sixoffices;
	model AntiIndex = fac1_1 fac2_1 OfficetypeBothSys /cl s;
	random SixOffices / s cl;
run;

					/* This ends the code for uses 5 and 6*/
					/* The syntax in this file is copyright by Robert B. Smith  2011*/





   
